(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    331055,       7852]
NotebookOptionsPosition[    316891,       7581]
NotebookOutlinePosition[    317331,       7597]
CellTagsIndexPosition[    317288,       7594]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Cyclic Orthodiagonal Quadrilaterals - Steiner point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547567434027576`*^9, 3.9547567507460346`*^9}, {3.955503984824476*^9, 
  3.955503986915159*^9}, {3.9555339604806595`*^9, 
  3.9555339647746162`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about cyclic-orthodiagonal \
quadrilaterals in the paper \[OpenCurlyDoubleQuote]More Shapes of Central \
Quadrilaterals\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954756786770439*^9, 
  3.954756791707377*^9}, {3.9611240901356926`*^9, 3.961124093989666*^9}, {
  3.9614130082037163`*^9, 
  3.9614130157394543`*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"9f6088f9-a2be-3140-964a-\
e41e398b8645"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"$Assumptions", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", ">", "0"}], ",", 
      RowBox[{"b", ">", "0"}], ",", 
      RowBox[{"c", ">", "0"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
      RowBox[{
       RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "condition", " ", "of", " ", "cyclicity", " ", "for", " ", "a", " ", 
    "quadrilateral", " ", "ABCD", " ", "with", " ", "D", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"cyclic", "=", 
  RowBox[{
   RowBox[{"Sustituirxyz", "[", 
    RowBox[{"circunscrita", ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "]"}], "==", 
   "0"}]}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.9471624606466045`*^9, 3.9471624614180145`*^9}, 3.947162515937668*^9, {
   3.9611242727855263`*^9, 3.9611243083762455`*^9}, {3.961124748921295*^9, 
   3.961124759249531*^9}},
 CellLabel->
  "In[297]:=",ExpressionUUID->"dfa71a50-4711-b245-a180-34a181143c58"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{
  3.9471628770241*^9, 3.947163230027064*^9, 3.947171547777752*^9, 
   3.947384354750984*^9, 3.947404248747368*^9, 3.947433914907507*^9, 
   3.9555040904905796`*^9, 3.9555315255427666`*^9, 3.95553399574336*^9, 
   3.956127853404518*^9, 3.959038687669794*^9, {3.961124356040678*^9, 
   3.9611243757510204`*^9}, 3.9611247958037796`*^9, 3.961126234026146*^9, 
   3.9614130354820843`*^9},
 CellLabel->
  "Out[299]=",ExpressionUUID->"32df8cbd-a801-4046-83e4-252f4e933252"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "condition", " ", "of", " ", "orthodiagonal", " ", "quadrilateral", " ", 
    "ABCD", " ", "with", " ", "D", 
    RowBox[{"{", 
     RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"ortho", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Perpendicular", "[", 
      RowBox[{"ptB", ",", "rtCA"}], "]"}], ".", 
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "==", "0"}]}]}]], "Input",
 CellChangeTimes->{
  3.961124279416905*^9, {3.9611247647427034`*^9, 3.961124784647835*^9}, {
   3.96114300907333*^9, 3.9611430097038727`*^9}},
 CellLabel->
  "In[300]:=",ExpressionUUID->"d79dce97-2742-4042-beca-1367e2fb9dc0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}], " ", "r"}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{
  3.955533995913969*^9, 3.956127854718777*^9, 3.9590386878367977`*^9, {
   3.9611243560626793`*^9, 3.961124375769022*^9}, 3.9611247958227463`*^9, 
   3.9611262374802456`*^9, 3.961413035551387*^9},
 CellLabel->
  "Out[300]=",ExpressionUUID->"ae4efc15-2069-4c71-92c5-f46d9e533b0d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-\
8944aef04ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"radialTrianglesOfQuadrilateral", ",", "centralQuadrilateral"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DiagonalPoint", "[", 
      RowBox[{"{", 
       RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
     RowBox[{"Punto", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P", ",", "R"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "parallelism"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "rectangle", " ", "quadrilateral"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rectangleQuadQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"P1_", ",", "P2_", ",", "P3_", ",", "P4_"}], "}"}], ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{"And", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"SonParalelas", "[", 
          RowBox[{
           RowBox[{"Recta", "[", 
            RowBox[{"P1", ",", "P2"}], "]"}], ",", 
           RowBox[{"Recta", "[", 
            RowBox[{"P3", ",", "P4"}], "]"}]}], "]"}], ",", "cond"}], "]"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"SonParalelas", "[", 
          RowBox[{
           RowBox[{"Recta", "[", 
            RowBox[{"P1", ",", "P4"}], "]"}], ",", 
           RowBox[{"Recta", "[", 
            RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}], ",", "cond"}], "]"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{"SonPerpendiculares", "[", 
          RowBox[{
           RowBox[{"Recta", "[", 
            RowBox[{"P1", ",", "P2"}], "]"}], ",", 
           RowBox[{"Recta", "[", 
            RowBox[{"P2", ",", "P3"}], "]"}]}], "]"}], ",", "cond"}], "]"}]}],
       "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.954755422028537*^9, 3.954755444302299*^9}, {
   3.954755510189615*^9, 3.9547556654655304`*^9}, {3.954756246303211*^9, 
   3.954756258310093*^9}, {3.954756539544531*^9, 3.954756557385113*^9}, {
   3.954756592197891*^9, 3.954756630631082*^9}, {3.954756965437847*^9, 
   3.954756984534746*^9}, {3.9547570451409245`*^9, 3.9547570732294483`*^9}, {
   3.9547571716004887`*^9, 3.9547571856117535`*^9}, {3.9547572771795826`*^9, 
   3.954757312322375*^9}, {3.95475745528866*^9, 3.954757469730625*^9}, {
   3.954757619426098*^9, 3.9547576217454853`*^9}, 3.954757823439115*^9, {
   3.954758024281746*^9, 3.954758036096319*^9}, 3.9547580746525097`*^9, {
   3.9547582109077053`*^9, 3.954758249530725*^9}, {3.956133725153715*^9, 
   3.956133750147482*^9}, {3.959042647062034*^9, 3.959042647245504*^9}, {
   3.959042723535932*^9, 3.959042724364486*^9}, {3.961124804470951*^9, 
   3.9611248046356945`*^9}, {3.9611248367340107`*^9, 3.961124841540367*^9}, {
   3.9611248791166687`*^9, 3.9611248990334473`*^9}, {3.961124933551544*^9, 
   3.961124935337866*^9}, {3.9611270094672737`*^9, 3.9611270100306416`*^9}, 
   3.9614130275898533`*^9},
 CellLabel->
  "In[301]:=",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 3.946441726397751*^9}, {3.9561372305254383`*^9, 
  3.9561372360300903`*^9}, {3.956137322420559*^9, 3.956137323751978*^9}, {
  3.9561374910757217`*^9, 
  3.956137494516241*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV1sU1e+/+3n5eK58MWTy1wg8ciylAukCkWRHhA6Si6CWkUKqFUU0SLL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    "], {{0, 300.2264150943396}, {833.4339622641509, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{833.4339622641509, 300.2264150943396},
  PlotRange->{{0, 833.4339622641509}, {0, 300.2264150943396}}]], "Input",
 CellChangeTimes->{3.956137328142054*^9, 3.956137472932368*^9},
 CellLabel->
  "In[311]:=",ExpressionUUID->"9f7389c4-33a2-5c45-89f8-ab6b14bf70cc"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV1sU1e+/+3n5eK58MWTy1wg8ciylAukCkWRHhA6Si6CWkUKqFUU0SLL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    "], {{0, 300.2264150943396}, {833.4339622641509, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{833.4339622641509, 300.2264150943396},
  PlotRange->{{0, 833.4339622641509}, {0, 300.2264150943396}}]], "Output",
 CellChangeTimes->{3.961413035586255*^9},
 CellLabel->
  "Out[311]=",ExpressionUUID->"00f1040d-9984-48df-8f14-3302b623b62f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "the", " ", "Steiner", " ", "point", " ", "of", " ", "a", " ", "cyclic", " ",
     "quadrilateral", " ", "is", " ", "the", " ", "circumcenter", " ", "of", " ",
     "the", " ", "quadrilateral"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"ptE", "=", "ptO"}]}]], "Input",
 CellChangeTimes->{{3.955532028301876*^9, 3.955532030902384*^9}, {
  3.9611246596127872`*^9, 3.9611247098872166`*^9}},
 CellLabel->
  "In[312]:=",ExpressionUUID->"cbc436a4-ceef-904d-95b0-34e8125b049a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9555320321457787`*^9, 3.955534061993798*^9, 3.956127913886209*^9, 
   3.9590387777309895`*^9, 3.959039771457701*^9, 3.959039810552431*^9, 
   3.959040051103346*^9, {3.961124356091648*^9, 3.9611243757730217`*^9}, 
   3.961124949201599*^9, 3.961126281772255*^9, 3.9614130355941353`*^9},
 CellLabel->
  "Out[312]=",ExpressionUUID->"6b587407-a587-489b-b57f-425cc4729fca"]
}, Open  ]],

Cell["\<\
If  ABCD  is cyclic and orthodiagonal the vertex D has the following \
barycentric coordinates:\
\>", "Text",
 CellChangeTimes->{{3.95613360297962*^9, 3.956133627074079*^9}, {
  3.9611244147187977`*^9, 
  3.9611244505909977`*^9}},ExpressionUUID->"b6dde599-e3c0-334a-bc10-\
bf8a1c438121"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptD", "=", 
  RowBox[{"-", 
   RowBox[{"SegundaInterseccionCircunferencia", "[", 
    RowBox[{
     RowBox[{"Pie", "[", 
      RowBox[{"ptB", ",", "rtCA"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptB", ",", "ptC", ",", "ptA"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{3.956138683488601*^9},
 CellLabel->
  "In[313]:=",ExpressionUUID->"1355c773-57b2-e644-9a56-f51ae54f0eb7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9561336307272625`*^9, 3.956138684728754*^9, 
  3.959039621142027*^9, 3.9590397773490505`*^9, 3.959039812624841*^9, 
  3.961124949240593*^9, 3.961125816525154*^9, 3.9611262898931236`*^9, 
  3.9614130356221046`*^9},
 CellLabel->
  "Out[313]=",ExpressionUUID->"d1d069f8-bdc8-4155-9a77-2aac316e3f8d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGHI  rectangle", "Section",
 CellChangeTimes->{{3.959043222561426*^9, 
  3.959043229382025*^9}},ExpressionUUID->"b3f7eaa1-eef4-db4b-b0a8-\
80b2b8a1c9ee"],

Cell[CellGroupData[{

Cell["X \[Element] \[DoubleStruckCapitalM]", "Subsection",
 CellChangeTimes->{{3.961124496287842*^9, 
  3.961124520430357*^9}},ExpressionUUID->"38d991a1-469d-ab47-803b-\
cb9aa78e1b2e"],

Cell["\<\
If  n\[Element]\[DoubleStruckCapitalM] then, by lemma 7.4,  F,G,H,I are the \
midpoints of AB, BC, CD, DA respectively. Therefore FG || AC, FG=AC/2, GH || \
BD, GH=BD/2, HI || CA, HI=CA/2, IF || BD, IF=BD/2. Hence FGHI is a rectangle.\
\>", "Text",
 CellChangeTimes->{{3.9590439954835443`*^9, 3.959044041168476*^9}, {
  3.959044151810156*^9, 3.9590444167704334`*^9}, {3.95904446076993*^9, 
  3.9590444797297*^9}, {3.959044539681553*^9, 
  3.959044541526989*^9}},ExpressionUUID->"7d1c4f19-60e6-8d42-82db-\
d0262afd8a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (2) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.959042518840568*^9}, 
   3.959042808998218*^9},ExpressionUUID->"0662e858-35c2-8448-ba35-\
211b8b39d356"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"2", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
  3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
  3.959042783496212*^9}},
 CellLabel->
  "In[314]:=",ExpressionUUID->"e962ad31-9e0e-9e4c-93f3-0377f4dd0b8a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.9590390314779625`*^9, 3.9590392471235714`*^9, 
   3.959039735648596*^9, 3.9590398043224545`*^9, 3.9590400722882137`*^9, 
   3.959042551974605*^9, 3.95904260456031*^9, {3.959042771015688*^9, 
   3.959042784076092*^9}, 3.9611249697861004`*^9, 3.9611262958279514`*^9, {
   3.961126559633869*^9, 3.9611265666809845`*^9}, 3.961413035828609*^9},
 CellLabel->
  "Out[315]=",ExpressionUUID->"a9843644-87e6-4866-8050-a286d177e8ec"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (148)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.959042518840568*^9}, {3.959042812241876*^9, 
   3.9590428156624317`*^9}},ExpressionUUID->"d71ab223-05ca-4544-978d-\
d729463ed014"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"148", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
   3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
   3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
   3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
   3.959042783496212*^9}, {3.959042819576639*^9, 3.959042821260608*^9}, {
   3.9611250451692505`*^9, 3.9611250910070553`*^9}, {3.9611251766275673`*^9, 
   3.9611252040962696`*^9}, {3.961125388583084*^9, 3.961125397288124*^9}, 
   3.961125427400099*^9, {3.9611255185686665`*^9, 3.961125545391737*^9}, {
   3.961126313985876*^9, 3.961126354999836*^9}},
 CellLabel->
  "In[316]:=",ExpressionUUID->"84a9d925-ec0b-2846-a5b8-e4d186c6f2bd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9611263030469475`*^9, 3.9611263559772263`*^9}, 
   3.961126575676079*^9, 3.9611270827178345`*^9, 3.961413036065516*^9},
 CellLabel->
  "Out[317]=",ExpressionUUID->"85126cb1-57b5-40e0-8bec-224752ba13b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "EFGH", " ", "and", " ", "ABCD", " ", "have", " ", "the", " ", "same", " ",
     "diagonal", " ", "point"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"PuntosIguales", "[", 
   RowBox[{
    RowBox[{"DiagonalPoint", "[", 
     RowBox[{"{", 
      RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}], ",", 
    RowBox[{"DiagonalPoint", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9611264955305424`*^9, 3.961126536673191*^9}, {
  3.9611267116392765`*^9, 3.9611267589730167`*^9}, {3.961127030067648*^9, 
  3.961127101196253*^9}},
 CellLabel->
  "In[318]:=",ExpressionUUID->"16e219f4-421d-e744-8c16-405a3b08bb07"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9611265808212166`*^9, {3.9611270790227604`*^9, 3.9611271020309143`*^9}, 
   3.96141303610073*^9},
 CellLabel->
  "Out[318]=",ExpressionUUID->"82fe17cf-b582-4891-a91f-46b057e7eaa7"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (149)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.959042518840568*^9}, {3.959042812241876*^9, 
   3.959042833824413*^9}},ExpressionUUID->"40fca688-7c37-8743-95aa-\
5edb53bf5423"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"149", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
  3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
  3.959042783496212*^9}, {3.959042819576639*^9, 3.959042837768774*^9}},
 CellLabel->
  "In[319]:=",ExpressionUUID->"62c68820-999e-3549-b47b-6a422829c1ed"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.9590390314779625`*^9, 3.9590392471235714`*^9, 
   3.959039735648596*^9, 3.9590398043224545`*^9, 3.9590400722882137`*^9, 
   3.959042551974605*^9, 3.95904260456031*^9, {3.959042771015688*^9, 
   3.959042784076092*^9}, {3.959042822578695*^9, 3.959042843477779*^9}, {
   3.961126348574936*^9, 3.9611263612279224`*^9}, 3.9611265906531563`*^9, 
   3.9611271252589684`*^9, 3.961413043982811*^9},
 CellLabel->
  "Out[320]=",ExpressionUUID->"fa09ebb2-93d0-43bf-9ed8-d4d0b5e7c2f9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "EFGH", " ", "and", " ", "ABCD", " ", "have", " ", "the", " ", "same", " ",
     "diagonal", " ", "point"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"PuntosIguales", "[", 
   RowBox[{
    RowBox[{"DiagonalPoint", "[", 
     RowBox[{"{", 
      RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}], ",", 
    RowBox[{"DiagonalPoint", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9611264955305424`*^9, 3.961126536673191*^9}, {
  3.9611267749826927`*^9, 3.9611267761218586`*^9}, {3.9611271169149017`*^9, 
  3.9611271335208206`*^9}},
 CellLabel->
  "In[321]:=",ExpressionUUID->"0388a793-24c8-d949-94c4-d81d546ae728"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9611265951117954`*^9, {3.9611271265105915`*^9, 3.961127134206152*^9}, 
   3.961413044071824*^9},
 CellLabel->
  "Out[321]=",ExpressionUUID->"5afcd25d-ce34-4231-8b06-5452da46e4f9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (150)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.959042518840568*^9}, {3.959042812241876*^9, 3.9590428156624317`*^9}, {
   3.959042850847431*^9, 
   3.959042851271646*^9}},ExpressionUUID->"e505ada7-2e7e-dd48-aa2d-\
c3724fcf5509"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"150", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
  3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
  3.959042783496212*^9}, {3.959042819576639*^9, 3.959042821260608*^9}, {
  3.959042855169651*^9, 3.959042855794712*^9}},
 CellLabel->
  "In[322]:=",ExpressionUUID->"f0155be2-2f05-cf4e-ae9a-62778914c3a4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.9590390314779625`*^9, 3.9590392471235714`*^9, 
   3.959039735648596*^9, 3.9590398043224545`*^9, 3.9590400722882137`*^9, 
   3.959042551974605*^9, 3.95904260456031*^9, {3.959042771015688*^9, 
   3.959042784076092*^9}, 3.959042822578695*^9, 3.9590428609966373`*^9, 
   3.9611263940375614`*^9, 3.961126605501049*^9, 3.961127147917454*^9, 
   3.961413051159857*^9},
 CellLabel->
  "Out[323]=",ExpressionUUID->"e4d331bd-78e9-4e1e-846e-a6d5a63dee32"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "EFGH", " ", "and", " ", "ABCD", " ", "have", " ", "the", " ", "same", " ",
     "diagonal", " ", "point"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"PuntosIguales", "[", 
   RowBox[{
    RowBox[{"DiagonalPoint", "[", 
     RowBox[{"{", 
      RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}], ",", 
    RowBox[{"DiagonalPoint", "[", 
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9611264955305424`*^9, 3.961126536673191*^9}, {
   3.9611267786947594`*^9, 3.961126779809164*^9}, 3.9611271419860954`*^9},
 CellLabel->
  "In[324]:=",ExpressionUUID->"4e909f10-304e-f343-b54a-a5539b5aa9fb"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611266087952633`*^9, 3.9611271502640553`*^9, 
  3.9614130512284603`*^9},
 CellLabel->
  "Out[324]=",ExpressionUUID->"14d51f78-009d-4e64-bcc1-fcff5d6d09cb"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (402)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.959042518840568*^9}, {3.959042812241876*^9, 3.9590428156624317`*^9}, {
   3.9590428746726446`*^9, 
   3.959042875720541*^9}},ExpressionUUID->"bce8ffbf-6470-4d4a-b61d-\
047d9524fe7c"],

Cell[TextData[{
 "Since  X(402) contains Conway symbols we must use the substitution sustC. \n\
",
 StyleBox["Remind that centroETCTriangulo[ptX,trT] does not work if the \
coordinates of ptX contain a Conway symbol !",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",
 CellChangeTimes->{{3.95613881758579*^9, 3.956139005893421*^9}, {
  3.956139037861418*^9, 3.95613903833988*^9}, {3.959042965161476*^9, 
  3.959042966222849*^9}},ExpressionUUID->"0488d9d0-e123-f34d-b693-\
77216d22b638"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X402", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"ETC", "[", 
     RowBox[{"[", 
      RowBox[{"402", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9561369846485767`*^9, 3.956137021316189*^9}, {
  3.959042973753977*^9, 3.959042974857418*^9}, {3.9611264036806717`*^9, 
  3.961126406020033*^9}},
 CellLabel->
  "In[325]:=",ExpressionUUID->"a8dc1f20-a9fd-534a-8543-04975878eac5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "4"], "+", 
      SuperscriptBox["b", "4"], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9561370010457478`*^9, 3.956137022200506*^9}, 
   3.959040107124998*^9, 3.9590429759711866`*^9, 3.961126408020853*^9, 
   3.9611266159674587`*^9, 3.961413051313714*^9},
 CellLabel->
  "Out[325]=",ExpressionUUID->"478dda98-b234-442f-abc2-48e5ce1591b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X402", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
  3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
  3.959042783496212*^9}, {3.959042819576639*^9, 3.959042821260608*^9}, {
  3.9590428810967245`*^9, 3.9590428821452303`*^9}, {3.9590430323793163`*^9, 
  3.959043033425638*^9}, {3.961126411896021*^9, 3.961126414300108*^9}},
 CellLabel->
  "In[326]:=",ExpressionUUID->"ca6df69d-1991-314f-8859-cb3767383b03"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.9590390314779625`*^9, 3.9590392471235714`*^9, 
   3.959039735648596*^9, 3.9590398043224545`*^9, 3.9590400722882137`*^9, 
   3.959042551974605*^9, 3.95904260456031*^9, {3.959042771015688*^9, 
   3.959042784076092*^9}, 3.959042822578695*^9, 3.959042929252882*^9, {
   3.9590430287204647`*^9, 3.959043034820526*^9}, 3.9611264162963543`*^9, 
   3.961126618676525*^9, 3.9614130518602448`*^9},
 CellLabel->
  "Out[327]=",ExpressionUUID->"fb248833-5f67-476f-ad7b-5d3d79bc1bc9"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (620)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.9590425188405685`*^9}, {3.9590428122418766`*^9, 
   3.9590428156624317`*^9}, {3.9590428746726456`*^9, 3.959042875720541*^9}, {
   3.959043106376089*^9, 
   3.9590431072082176`*^9}},ExpressionUUID->"4aea22f4-776a-be41-a8b9-\
989777d728b0"],

Cell["\<\
Since  X(620) contains Conway symbols we must use the substitution sustC. \
\>", "Text",
 CellChangeTimes->{{3.95613881758579*^9, 3.956139005893421*^9}, {
   3.956139037861418*^9, 3.95613903833988*^9}, {3.959042965161476*^9, 
   3.959042966222849*^9}, {3.9590430769591694`*^9, 3.959043085351324*^9}, 
   3.9590431558637657`*^9},ExpressionUUID->"12232b8a-f272-b549-8ee8-\
d7cf7e9e5a6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X620", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"ETC", "[", 
     RowBox[{"[", 
      RowBox[{"620", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9561369846485767`*^9, 3.956137021316189*^9}, {
  3.959042973753977*^9, 3.959042974857418*^9}, {3.9590430614491787`*^9, 
  3.959043064145012*^9}, {3.961126424896181*^9, 3.9611264275518684`*^9}},
 CellLabel->
  "In[328]:=",ExpressionUUID->"ba228ad3-4f69-3c44-812a-af2cbaadbe1a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "4"]}], "+", 
    SuperscriptBox["b", "4"], "+", 
    SuperscriptBox["c", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["c", "4"]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["c", "4"]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9561370010457478`*^9, 3.956137022200506*^9}, 
   3.959040107124998*^9, 3.9590429759711866`*^9, 3.959043065618219*^9, 
   3.9611264294699497`*^9, 3.9611266298535213`*^9, 3.96141305189212*^9},
 CellLabel->
  "Out[328]=",ExpressionUUID->"7e9c288c-6140-4b3c-823a-f5c7649c4c86"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X620", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
  3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
  3.959042783496212*^9}, {3.959042819576639*^9, 3.959042821260608*^9}, {
  3.9590428810967245`*^9, 3.9590428821452303`*^9}, {3.9590430323793163`*^9, 
  3.959043033425638*^9}, {3.9611264335765305`*^9, 3.9611264358242683`*^9}},
 CellLabel->
  "In[329]:=",ExpressionUUID->"64c7e346-1cde-af45-9f8d-c75632ddd3f4"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.9590390314779625`*^9, 3.9590392471235714`*^9, 
   3.959039735648596*^9, 3.9590398043224545`*^9, 3.9590400722882137`*^9, 
   3.959042551974605*^9, 3.95904260456031*^9, {3.959042771015688*^9, 
   3.959042784076092*^9}, 3.959042822578695*^9, 3.959042929252882*^9, {
   3.9590430287204647`*^9, 3.959043034820526*^9}, 3.9590430677138577`*^9, 
   3.9611264370695877`*^9, 3.9611266318149166`*^9, 3.961413052063635*^9},
 CellLabel->
  "Out[330]=",ExpressionUUID->"b3541b3c-8b5e-4d3c-befd-b12ac81f1c96"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (671)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.9590425188405685`*^9}, {3.9590428122418766`*^9, 
   3.9590428156624317`*^9}, {3.959042850847431*^9, 3.9590428512716465`*^9}, {
   3.959043125728014*^9, 
   3.9590431262640133`*^9}},ExpressionUUID->"c1108ee2-c5e2-f04e-b635-\
fe16a3ab9658"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"671", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
  3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
  3.959042783496212*^9}, {3.959042819576639*^9, 3.959042821260608*^9}, {
  3.959042855169651*^9, 3.959042855794712*^9}, {3.959043129698019*^9, 
  3.959043131817095*^9}},
 CellLabel->
  "In[331]:=",ExpressionUUID->"4c0d9e81-3fb1-fa4b-aca2-a4aadcae1c00"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.9590390314779625`*^9, 3.9590392471235714`*^9, 
   3.959039735648596*^9, 3.9590398043224545`*^9, 3.9590400722882137`*^9, 
   3.959042551974605*^9, 3.95904260456031*^9, {3.959042771015688*^9, 
   3.959042784076092*^9}, 3.959042822578695*^9, 3.9590428609966373`*^9, 
   3.959043133080572*^9, 3.961126444068636*^9, 3.9611266400385914`*^9, 
   3.9614130523139277`*^9},
 CellLabel->
  "Out[332]=",ExpressionUUID->"e512d371-7314-4fe7-9ca0-8bb57e43394c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (903)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.959042518840568*^9}, {3.959042812241876*^9, 3.9590428156624317`*^9}, {
   3.959042850847431*^9, 3.959042851271646*^9}, {3.959043138159689*^9, 
   3.9590431401206627`*^9}},ExpressionUUID->"457419a0-d4b9-8e49-b136-\
a41df8c97b0f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"903", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"rectangleQuadQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}, {3.9590425506102524`*^9, 3.959042550896929*^9}, {
  3.959042581335748*^9, 3.959042612847784*^9}, {3.959042748699606*^9, 
  3.959042783496212*^9}, {3.959042819576639*^9, 3.959042821260608*^9}, {
  3.959042855169651*^9, 3.959042855794712*^9}, {3.959043146571045*^9, 
  3.959043147305324*^9}},
 CellLabel->
  "In[333]:=",ExpressionUUID->"9ca75056-3d9b-bc42-b54c-6a2e5c3b0480"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9561387298765984`*^9, 3.9590390314779625`*^9, 3.9590392471235714`*^9, 
   3.959039735648596*^9, 3.9590398043224545`*^9, 3.9590400722882137`*^9, 
   3.959042551974605*^9, 3.95904260456031*^9, {3.959042771015688*^9, 
   3.959042784076092*^9}, 3.959042822578695*^9, 3.9590428609966373`*^9, 
   3.959043148655248*^9, 3.9611264519224415`*^9, 3.961126649602461*^9, 
   3.9614130526689167`*^9},
 CellLabel->
  "Out[334]=",ExpressionUUID->"72374a8f-c579-4b4f-8786-7f7280185d06"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI  bicentric", "Section",
 CellChangeTimes->{{3.959043222561426*^9, 3.959043229382025*^9}, {
  3.9611274581857357`*^9, 
  3.961127460488943*^9}},ExpressionUUID->"0e10dd37-8104-c94a-8c65-\
649cdab12f3f"],

Cell[CellGroupData[{

Cell["X (3) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 3.9561385171560116`*^9}, {3.959042501598999*^9, 
   3.959042518840568*^9}, 3.959042808998218*^9, 
   3.9611277164890537`*^9},ExpressionUUID->"fba59776-9148-5b4f-9075-\
82284f0661ad"],

Cell["See Theorem 7.19 (synthetic proof)", "Text",
 CellChangeTimes->{{3.9611215643672256`*^9, 3.961121661284836*^9}, {
  3.9611275331287193`*^9, 
  3.9611275340160446`*^9}},ExpressionUUID->"ce4ce0e9-b23f-4647-af94-\
bee9eb572196"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI  equidiagonal", "Section",
 CellChangeTimes->{{3.959043222561426*^9, 
  3.959043249599575*^9}},ExpressionUUID->"e90dccc5-e9f3-874d-913b-\
b129f6ad583d"],

Cell[CellGroupData[{

Cell["X (13) --> FH=GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956138509460258*^9, 
   3.9561385171560116`*^9}},ExpressionUUID->"d11bcbe3-4466-8d48-8d95-\
b256984be2d3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"13", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "]"}], "//.", 
  "sustS"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956138701182129*^9, 
  3.956138726774135*^9}},
 CellLabel->
  "In[335]:=",ExpressionUUID->"016768b1-05ea-2b45-823e-7a5dd3499771"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9561387298765984`*^9, 3.9590390314779625`*^9, 
  3.9590392471235714`*^9, 3.959039735648596*^9, 3.9590398043224545`*^9, 
  3.9590400722882137`*^9, 3.9611273267546787`*^9, 3.961413055400062*^9},
 CellLabel->
  "Out[336]=",ExpressionUUID->"3dd73583-2daa-48d4-8ae8-d9172d2e3bb6"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (14) --> FH=GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956133948275925*^9, 3.956133948328598*^9}, {3.9561385237726536`*^9, 
   3.956138524547638*^9}},ExpressionUUID->"6633380b-83f3-f441-b19e-\
d07114df9870"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"14", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "]"}], "//.", 
  "sustS"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133961281576*^9, 
  3.956133961329883*^9}, {3.956138711838707*^9, 3.956138738462588*^9}},
 CellLabel->
  "In[337]:=",ExpressionUUID->"1082b01d-c232-1b4d-a8b7-8fb61d00c4b2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9561387420021095`*^9, 3.959040096722412*^9, 
  3.961127334800516*^9, 3.961413058178027*^9},
 CellLabel->
  "Out[338]=",ExpressionUUID->"fc0a8230-5725-4b61-bddd-4490f21930ac"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (616) --> FH=GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654343`*^9}, {3.956138527604374*^9, 
   3.9561385284116287`*^9}},ExpressionUUID->"18617412-2e36-7240-9798-\
f3b34cbd7168"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"616", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "]"}], "//.", 
  "sustS"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956138751734125*^9, 3.9561387593982983`*^9}},
 CellLabel->
  "In[339]:=",ExpressionUUID->"3c72cbc3-5f16-9044-88e8-afb06edba80b"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.956138762163542*^9, 3.959040099324947*^9, 
  3.9611273391896496`*^9, 3.961413061227852*^9},
 CellLabel->
  "Out[340]=",ExpressionUUID->"094a49dd-7569-41ae-a422-7ffaee816dff"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (617) --> FH=GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561340112757664`*^9, 3.9561340119402046`*^9}, {3.9561385328203316`*^9, 
   3.956138533540703*^9}},ExpressionUUID->"b5e6df1a-2082-cc42-bb30-\
b93687b52e11"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"617", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "]"}], "//.", 
  "sustS"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.9561340176374717`*^9, 
  3.9561340183072586`*^9}, {3.956138771278202*^9, 3.956138778448374*^9}},
 CellLabel->
  "In[341]:=",ExpressionUUID->"7caf2741-b5fa-c647-9f52-53104212eb4a"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.956138781367874*^9, 3.959040102330921*^9, 
  3.9611273453902225`*^9, 3.961413064319133*^9},
 CellLabel->
  "Out[342]=",ExpressionUUID->"a63f64cb-f668-488a-a12a-fb8fd878c909"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (618) --> FH=GI ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.956134032305361*^9, 3.9561340328094006`*^9}, {3.9561351619190273`*^9, 
   3.956135162870985*^9}, 3.9561370694105015`*^9, {3.9561385360197983`*^9, 
   3.9561385364684086`*^9}},ExpressionUUID->"7e381a03-af88-b147-986a-\
ab066250fa85"],

Cell[TextData[{
 "Since  X(618) contains Conway symbols we must use the substitution sustC. \n\
",
 StyleBox["Remind that centroETCTriangulo[ptX,trT] does not work if the \
coordinates of ptX contain a Conway symbol !",
  FontColor->RGBColor[1, 0, 0]]
}], "Text",
 CellChangeTimes->{{3.9561388175857906`*^9, 3.956139005893421*^9}, {
  3.956139037861418*^9, 
  3.95613903833988*^9}},ExpressionUUID->"0f2b9cc4-3b58-b842-99fe-\
613c93037ba0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X618", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"ETC", "[", 
     RowBox[{"[", 
      RowBox[{"618", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9561369846485767`*^9, 3.956137021316189*^9}, {
  3.9611273511374645`*^9, 3.961127354637949*^9}},
 CellLabel->
  "In[343]:=",ExpressionUUID->"5f506d39-bf71-f34b-acbc-f3aec79462ae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     SuperscriptBox["a", "4"]}], "-", 
    SuperscriptBox["b", "4"], "-", 
    SuperscriptBox["c", "4"], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"], " ", "S"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["b", "4"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "-", 
    SuperscriptBox["c", "4"], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"], " ", "S"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          RowBox[{
           SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "4"]}], "-", 
    SuperscriptBox["b", "4"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9561370010457478`*^9, 3.956137022200506*^9}, 
   3.959040107124998*^9, 3.9611273567315044`*^9, 3.961413064404978*^9},
 CellLabel->
  "Out[343]=",ExpressionUUID->"3b39365b-e23b-4b93-987d-c5665109ca61"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X618", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "]"}], "//.", 
  "sustS"}]}], "Input",
 CellChangeTimes->{{3.956134842147209*^9, 3.956134843691174*^9}, 
   3.956135040516331*^9, {3.9561366126532364`*^9, 3.9561366591478004`*^9}, {
   3.956137030287377*^9, 3.956137037652506*^9}, {3.95613901396002*^9, 
   3.956139021126745*^9}, {3.9611273603062286`*^9, 3.9611273627612667`*^9}},
 CellLabel->
  "In[344]:=",ExpressionUUID->"d682c552-036b-6547-b74f-f39f3a9f42e4"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.95613902633222*^9, 3.959040112023123*^9, 
  3.9611273664668865`*^9, 3.961413068297304*^9},
 CellLabel->
  "Out[345]=",ExpressionUUID->"05ab13ce-e89b-4a2c-8958-5a41716423cd"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (619) --> FH=GI ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654347`*^9}, {3.956135663169922*^9, 
   3.9561356632601547`*^9}, {3.956135701846995*^9, 3.9561357200026684`*^9}, 
   3.956137076226773*^9, {3.956138539044327*^9, 
   3.956138539456184*^9}},ExpressionUUID->"752b74f9-260b-a941-8310-\
48671f3b7edb"],

Cell["\<\
Since   X (619)  contains  Conway  symbols  we  must  use  the  substitution  \
sustC . \
\>", "Text",
 CellChangeTimes->{{3.956139051281273*^9, 
  3.956139060748251*^9}},ExpressionUUID->"9e500d9b-c6d2-e94e-bba1-\
5180f2495e0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"X619", "=", 
  RowBox[{"Simplificar", "[", 
   RowBox[{
    RowBox[{"ETC", "[", 
     RowBox[{"[", 
      RowBox[{"619", ",", "2"}], "]"}], "]"}], "/.", "sustC"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.956137080572626*^9, 3.956137080611079*^9}, {
  3.9611273769051514`*^9, 3.9611273793779297`*^9}},
 CellLabel->
  "In[346]:=",ExpressionUUID->"6220077a-98f6-0743-b979-84bae9a737a0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox["a", "4"]}], "+", 
    SuperscriptBox["b", "4"], "+", 
    SuperscriptBox["c", "4"], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       SuperscriptBox["c", "2"]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"], " ", "S"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "-", 
       RowBox[{
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["b", "4"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["c", "4"], "+", 
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", 
     SuperscriptBox["c", "2"], " ", "S"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "+", 
    SuperscriptBox["b", "4"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["c", "4"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        SuperscriptBox["b", "2"]}], "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["c", "2"]}], "+", 
       RowBox[{"2", " ", 
        SqrtBox["3"], " ", "S"}]}], ")"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.956137081248598*^9, 3.959040115198141*^9, 
  3.9611273803531322`*^9, 3.961413068380569*^9},
 CellLabel->
  "Out[346]=",ExpressionUUID->"a5516e21-81e7-4db6-8545-22cbcfa07b6f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"X619", ",", "ptE"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptF", ",", "ptH"}], "]"}], "-", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}], "]"}], "//.", 
  "sustS"}]}], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956135670965465*^9, 3.9561356709823895`*^9}, {
  3.956137089253795*^9, 3.956137090028921*^9}, {3.9561390645907726`*^9, 
  3.956139071830572*^9}, {3.9611273837134857`*^9, 3.961127386009041*^9}},
 CellLabel->
  "In[347]:=",ExpressionUUID->"52507028-9665-a544-85f3-ac0a3c109c3d"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.956139074649937*^9, 3.9590401226413403`*^9, 
  3.9611273902919636`*^9, 3.961413072229895*^9},
 CellLabel->
  "Out[348]=",ExpressionUUID->"fe50dc51-ca25-4129-8978-aa4426d2a149"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI  isosceles trapezoid", "Section",
 CellChangeTimes->{{3.959043222561426*^9, 3.959043229382025*^9}, {
  3.9590432798079777`*^9, 
  3.959043285687912*^9}},ExpressionUUID->"7d6e6590-ad3b-aa4d-ad91-\
9f5ad327fd89"],

Cell[CellGroupData[{

Cell["X (154) --> FH|| GI and FI=GH ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654347`*^9}, {3.956135663169922*^9, 
   3.9561356632601547`*^9}, {3.956135701846995*^9, 3.9561357200026684`*^9}, 
   3.956137076226773*^9, {3.95613751986743*^9, 3.95613752045203*^9}, {
   3.9561384305568666`*^9, 3.9561384970540333`*^9}, {3.959040177991894*^9, 
   3.959040193580511*^9}, 
   3.959043324288233*^9},ExpressionUUID->"989255a1-1383-b542-868f-\
a49a786558e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"154", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956135670965465*^9, 3.9561356709823895`*^9}, {
  3.956137089253795*^9, 3.956137090028921*^9}, {3.956137556421686*^9, 
  3.956137557324765*^9}},
 CellLabel->
  "In[349]:=",ExpressionUUID->"1c153a5c-4009-fe45-a749-01cd9484889b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"13", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "9"}], " ", 
            SuperscriptBox["b", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.956133674147861*^9, 3.95613369983214*^9}, {
   3.9561337640359592`*^9, 3.956133783771754*^9}, 3.956133997494936*^9, 
   3.95613568001593*^9, 3.9561370919965*^9, 3.956137558202154*^9, 
   3.9590401457241764`*^9, 3.961128472394684*^9, 3.961413072535735*^9},
 CellLabel->
  "Out[349]=",ExpressionUUID->"8e609761-250f-4500-8a7e-3ac09f3b5de4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Numerator", "[", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptF", ",", "ptI"}], "]"}], "-", 
     RowBox[{"CuadradoDistancia", "[", 
      RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}], "]"}], "//.", 
  "sustS"}]], "Input",
 CellChangeTimes->{{3.956133810853796*^9, 3.956133856566984*^9}, {
  3.956133891246702*^9, 3.9561339300344963`*^9}, {3.9561376432387643`*^9, 
  3.956137649989392*^9}},
 CellLabel->
  "In[350]:=",ExpressionUUID->"61a22e0d-3fa1-7946-a415-fd7e4b1239e5"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.956133827980038*^9, 3.9561338700263786`*^9}, {
   3.9561339007064686`*^9, 3.9561339327606487`*^9}, 3.95613400414858*^9, 
   3.9561357153591194`*^9, 3.9561370976494255`*^9, 3.956137650775967*^9, 
   3.959040159151527*^9, 3.9611284786049767`*^9, 3.9614130725592947`*^9},
 CellLabel->
  "Out[350]=",ExpressionUUID->"216fd11b-86aa-40c7-876a-dd442b3a4828"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956137658856808*^9, 3.9561377231097336`*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"eb63601f-c088-de4e-bb6a-54581bac5a47"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.956137707144516*^9, 3.956137723967192*^9}, 
   3.9590401605642786`*^9, 3.9611284864785385`*^9, 3.961413072679435*^9},
 CellLabel->
  "Out[351]=",ExpressionUUID->"518e51c1-0c2d-4c0e-b59f-faf2075dda1e"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI  trapezoid", "Section",
 CellChangeTimes->{{3.959043222561426*^9, 3.959043229382025*^9}, {
  3.9590433132875156`*^9, 
  3.9590433154085293`*^9}},ExpressionUUID->"432e527b-bb62-1240-8db7-\
dae7d756a3a5"],

Cell[CellGroupData[{

Cell["X (26) --> FH|| GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654343`*^9}, {3.956135663169922*^9, 
   3.9561356632601547`*^9}, {3.9561357018469944`*^9, 3.9561357200026684`*^9}, 
   3.9561370762267723`*^9, {3.9561375198674297`*^9, 3.95613752045203*^9}, {
   3.956138143100231*^9, 3.956138143650751*^9}, {3.95613826151643*^9, 
   3.9561382663501263`*^9}},ExpressionUUID->"267d676c-6e13-0042-bf7a-\
cb90e9b09112"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"26", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956135670965465*^9, 3.9561356709823895`*^9}, {
  3.956137089253795*^9, 3.956137090028921*^9}, {3.956137556421686*^9, 
  3.956137557324765*^9}, {3.9561381585255146`*^9, 3.9561381605417557`*^9}},
 CellLabel->
  "In[352]:=",ExpressionUUID->"4ad77f81-e40f-5b4c-9a0b-bf218f58bae7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], "5"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"18", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "3"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "3"], " ", 
         SuperscriptBox["b", "3"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "3"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        SuperscriptBox["b", "6"], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        SuperscriptBox["c", "6"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        SuperscriptBox["b", "6"], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        SuperscriptBox["c", "6"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "-", 
        RowBox[{
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"17", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "10"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "+", 
           SuperscriptBox["c", "10"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "10"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "+", 
           SuperscriptBox["c", "10"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "-", 
        RowBox[{
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"17", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "10"], "-", 
           RowBox[{
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "+", 
           SuperscriptBox["c", "10"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "10"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "10"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "5"], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "12"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "5"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "12"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"21", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"13", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"20", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "10"], "-", 
         RowBox[{
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"]}], "-", 
         SuperscriptBox["c", "10"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "10"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "10"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "10"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"7", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "8"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        SuperscriptBox["b", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "8"], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.956133674147861*^9, 3.95613369983214*^9}, {
   3.9561337640359592`*^9, 3.956133783771754*^9}, 3.956133997494936*^9, 
   3.95613568001593*^9, 3.9561370919965*^9, 3.956137558202154*^9, 
   3.9561381616754265`*^9, 3.95904020608111*^9, 3.961128511335623*^9, 
   3.96141307324025*^9},
 CellLabel->
  "Out[352]=",ExpressionUUID->"18e954d8-a73e-4d0b-b8e5-fc0970438ce1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956137658856808*^9, 3.9561377231097336`*^9}},
 CellLabel->
  "In[353]:=",ExpressionUUID->"734d1d57-5660-bc49-a08f-f32c088ce887"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.956137707144516*^9, 3.956137723967192*^9}, 
   3.956138180333702*^9, 3.961128513229864*^9, 3.961413073593717*^9},
 CellLabel->
  "Out[353]=",ExpressionUUID->"ad3dc591-b8d7-4a7d-b9b0-433a63cfd88d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (139) -->  FI|| GH", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654347`*^9}, {3.956135663169922*^9, 
   3.9561356632601547`*^9}, {3.956135701846995*^9, 3.9561357200026684`*^9}, 
   3.956137076226773*^9, {3.95613751986743*^9, 3.95613752045203*^9}, {
   3.956138143100231*^9, 3.956138143650751*^9}, {3.956138216980646*^9, 
   3.956138218924629*^9}, {3.9561382737727146`*^9, 
   3.956138282300596*^9}},ExpressionUUID->"80b26708-9c6d-aa4a-a30f-\
8a688aedef7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"139", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956135670965465*^9, 3.9561356709823895`*^9}, {
  3.956137089253795*^9, 3.956137090028921*^9}, {3.956137556421686*^9, 
  3.956137557324765*^9}, {3.9561381585255146`*^9, 3.9561381605417557`*^9}, {
  3.956138236420927*^9, 3.956138238141041*^9}},
 CellLabel->
  "In[354]:=",ExpressionUUID->"f14cc723-5f23-404e-b88f-383059162632"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      SuperscriptBox["b", "6"], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      SuperscriptBox["c", "6"], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "6"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "3"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.956133674147861*^9, 3.95613369983214*^9}, {
   3.9561337640359592`*^9, 3.956133783771754*^9}, 3.956133997494936*^9, 
   3.95613568001593*^9, 3.9561370919965*^9, 3.956137558202154*^9, 
   3.9561381616754265`*^9, 3.956138239213726*^9, 3.959040212498314*^9, 
   3.9611285220622616`*^9, 3.961413074031172*^9},
 CellLabel->
  "Out[354]=",ExpressionUUID->"8ab43b9c-1e72-4129-943f-ad70b20a9d69"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptI"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956137658856808*^9, 3.9561377231097336`*^9}, {
  3.9561382442049274`*^9, 3.956138247436804*^9}},
 CellLabel->
  "In[355]:=",ExpressionUUID->"f6fca7dc-4d97-d84d-8628-7e2f6ab7cb9d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.956137707144516*^9, 3.956137723967192*^9}, 
   3.956138180333702*^9, 3.956138248383009*^9, 3.9590402134383082`*^9, 
   3.961128523014614*^9, 3.961413074058846*^9},
 CellLabel->
  "Out[355]=",ExpressionUUID->"6dd5093b-8509-419a-ab50-46ad05fbc504"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (155) -->  FH|| GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654343`*^9}, {3.956135663169922*^9, 
   3.9561356632601547`*^9}, {3.9561357018469944`*^9, 3.9561357200026684`*^9}, 
   3.9561370762267723`*^9, {3.9561375198674297`*^9, 3.95613752045203*^9}, {
   3.956138143100231*^9, 3.956138143650751*^9}, {3.956138216980646*^9, 
   3.956138218924629*^9}, {3.9561382737727146`*^9, 3.956138282300596*^9}, {
   3.9561383131157074`*^9, 
   3.9561383190204315`*^9}},ExpressionUUID->"9252b059-d9a4-c541-93ef-\
f5f0923c8d80"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"155", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956135670965465*^9, 3.9561356709823895`*^9}, {
  3.956137089253795*^9, 3.956137090028921*^9}, {3.956137556421686*^9, 
  3.956137557324765*^9}, {3.9561381585255146`*^9, 3.9561381605417557`*^9}, {
  3.956138236420927*^9, 3.956138238141041*^9}, {3.95613834651684*^9, 
  3.95613834772542*^9}},
 CellLabel->
  "In[356]:=",ExpressionUUID->"f4f5deaa-26fd-e048-ad2a-2a9b8be777f9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "8"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        SuperscriptBox["b", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "8"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "8"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"]}], "-", 
        SuperscriptBox["b", "6"], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["a", "6"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "3"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "8"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "8"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      SuperscriptBox["c", "8"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "6"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "6"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"]}], "+", 
        SuperscriptBox["b", "6"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.956133674147861*^9, 3.95613369983214*^9}, {
   3.9561337640359592`*^9, 3.956133783771754*^9}, 3.956133997494936*^9, 
   3.95613568001593*^9, 3.9561370919965*^9, 3.956137558202154*^9, 
   3.9561381616754265`*^9, 3.956138239213726*^9, 3.956138348100731*^9, 
   3.959040219658695*^9, 3.9611285271882286`*^9, 3.96141307442925*^9},
 CellLabel->
  "Out[356]=",ExpressionUUID->"055eddb2-88eb-424d-845f-b3f7c787a1b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956137658856808*^9, 3.9561377231097336`*^9}, {
  3.9561382442049274`*^9, 3.956138247436804*^9}, {3.956138356229286*^9, 
  3.9561383591505737`*^9}},
 CellLabel->
  "In[357]:=",ExpressionUUID->"5c96b08b-525b-1e42-a948-91cbf4ebca66"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.956137707144516*^9, 3.956137723967192*^9}, 
   3.956138180333702*^9, 3.956138248383009*^9, 3.9561383599675064`*^9, 
   3.959040220743679*^9, 3.961128528481249*^9, 3.96141307463048*^9},
 CellLabel->
  "Out[357]=",ExpressionUUID->"6ebf1e98-cc7d-4df6-8a32-70647363c7da"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (156) -->  FH|| GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654347`*^9}, {3.956135663169922*^9, 
   3.9561356632601547`*^9}, {3.956135701846995*^9, 3.9561357200026684`*^9}, 
   3.956137076226773*^9, {3.95613751986743*^9, 3.95613752045203*^9}, {
   3.956138143100231*^9, 3.956138143650751*^9}, {3.956138216980646*^9, 
   3.956138218924629*^9}, {3.9561382737727146`*^9, 3.956138282300596*^9}, {
   3.956138313115707*^9, 3.956138319020431*^9}, {3.9561383735962286`*^9, 
   3.956138373657783*^9}},ExpressionUUID->"6973bef7-b779-9044-992e-\
bd6df851436b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"156", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956135670965465*^9, 3.9561356709823895`*^9}, {
  3.956137089253795*^9, 3.956137090028921*^9}, {3.956137556421686*^9, 
  3.956137557324765*^9}, {3.9561381585255146`*^9, 3.9561381605417557`*^9}, {
  3.956138236420927*^9, 3.956138238141041*^9}, {3.95613834651684*^9, 
  3.95613834772542*^9}, {3.9561383854458923`*^9, 3.956138385510912*^9}},
 CellLabel->
  "In[358]:=",ExpressionUUID->"44b1a86f-db55-6343-b629-05c83c52c43e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"20", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"16", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "12"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "6"], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "10"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "+", 
        SuperscriptBox["b", "12"], "-", 
        RowBox[{
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "8"]}], "+", 
        SuperscriptBox["c", "12"], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"9", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"24", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"26", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"24", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "10"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "10"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "+", 
        SuperscriptBox["b", "12"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "10"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "8"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "10"]}], "-", 
        SuperscriptBox["c", "12"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"14", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"15", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6"}], " ", 
            SuperscriptBox["b", "10"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "6"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "10"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "12"], "-", 
        SuperscriptBox["b", "12"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "10"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "8"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "10"]}], "+", 
        SuperscriptBox["c", "12"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "10"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"14", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"15", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "10"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "10"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "10"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "5"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "5"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"14", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "12"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "6"], " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "8"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "10"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"]}], "+", 
         SuperscriptBox["c", "10"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "10"]}], "+", 
        SuperscriptBox["b", "10"], "+", 
        RowBox[{
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "8"]}], "-", 
        SuperscriptBox["c", "10"], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           SuperscriptBox["c", "6"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", 
            SuperscriptBox["b", "8"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "+", 
        SuperscriptBox["b", "10"], "+", 
        RowBox[{
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "8"]}], "-", 
        SuperscriptBox["c", "10"], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "8"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.956133674147861*^9, 3.95613369983214*^9}, {
   3.9561337640359592`*^9, 3.956133783771754*^9}, 3.956133997494936*^9, 
   3.95613568001593*^9, 3.9561370919965*^9, 3.956137558202154*^9, 
   3.9561381616754265`*^9, 3.956138239213726*^9, 3.956138348100731*^9, 
   3.956138386372242*^9, 3.9590402228045025`*^9, 3.9611285326360264`*^9, 
   3.9614130752229357`*^9},
 CellLabel->
  "Out[358]=",ExpressionUUID->"8b6aacb3-4b8a-41bb-baf4-1b3d960f2b22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956137658856808*^9, 3.9561377231097336`*^9}, {
  3.9561382442049274`*^9, 3.956138247436804*^9}, {3.956138356229286*^9, 
  3.9561383591505737`*^9}},
 CellLabel->
  "In[359]:=",ExpressionUUID->"1a411fb9-4961-7445-a011-74471fe1e539"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.956137707144516*^9, 3.956137723967192*^9}, 
   3.956138180333702*^9, 3.956138248383009*^9, {3.9561383599675064`*^9, 
   3.956138387764984*^9}, 3.959040226841116*^9, 3.961128534235615*^9, 
   3.9614130755026197`*^9},
 CellLabel->
  "Out[359]=",ExpressionUUID->"558703f4-abef-4a78-a899-e80b6d2a9701"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (157) -->  FH|| GI", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, 3.955534064576044*^9, {
   3.9561339861963043`*^9, 3.9561339882654347`*^9}, {3.956135663169922*^9, 
   3.9561356632601547`*^9}, {3.956135701846995*^9, 3.9561357200026684`*^9}, 
   3.956137076226773*^9, {3.95613751986743*^9, 3.95613752045203*^9}, {
   3.956138143100231*^9, 3.956138143650751*^9}, {3.956138216980646*^9, 
   3.956138218924629*^9}, {3.9561382737727146`*^9, 3.956138282300596*^9}, {
   3.956138313115707*^9, 3.956138319020431*^9}, {3.9561383735962286`*^9, 
   3.9561383968700066`*^9}},ExpressionUUID->"d60888f0-9f45-0343-ad43-\
14ff13743152"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"centralQuadrilateral", "[", 
   RowBox[{"157", ",", "ptE"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.956133672550749*^9, 3.9561336987942104`*^9}, {
  3.956133780179737*^9, 3.956133782684319*^9}, {3.956133994139154*^9, 
  3.9561339954500504`*^9}, {3.956135670965465*^9, 3.9561356709823895`*^9}, {
  3.956137089253795*^9, 3.956137090028921*^9}, {3.956137556421686*^9, 
  3.956137557324765*^9}, {3.9561381585255146`*^9, 3.9561381605417557`*^9}, {
  3.956138236420927*^9, 3.956138238141041*^9}, {3.95613834651684*^9, 
  3.95613834772542*^9}, {3.9561383854458923`*^9, 3.956138400546484*^9}},
 CellLabel->
  "In[360]:=",ExpressionUUID->"aca079f3-0fa4-dc4e-a7ae-7fda6e3e9bf9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "10"], "-", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "5"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        SuperscriptBox["b", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        SuperscriptBox["c", "8"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "10"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           SuperscriptBox["c", "8"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "8"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           SuperscriptBox["c", "8"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "10"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           SuperscriptBox["c", "8"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "5"], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "12"], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "5"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "12"], "-", 
      RowBox[{
       SuperscriptBox["a", "10"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"10", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"19", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"10", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"15", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "10"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "8"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "8"]}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["c", "10"]}]}], ")"}]}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "10"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "6"]}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "-", 
           SuperscriptBox["c", "8"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", 
            SuperscriptBox["b", "8"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "8"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "8"], "+", 
        SuperscriptBox["b", "8"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "4"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "6"]}], "-", 
        SuperscriptBox["c", "8"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.956133674147861*^9, 3.95613369983214*^9}, {
   3.9561337640359592`*^9, 3.956133783771754*^9}, 3.956133997494936*^9, 
   3.95613568001593*^9, 3.9561370919965*^9, 3.956137558202154*^9, 
   3.9561381616754265`*^9, 3.956138239213726*^9, 3.956138348100731*^9, {
   3.956138386372242*^9, 3.956138401435369*^9}, 3.959040228482155*^9, 
   3.9611285386609344`*^9, 3.9614130760094337`*^9},
 CellLabel->
  "Out[360]=",ExpressionUUID->"783d0beb-e6fe-4b20-8601-26d701bded44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelQ", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptH"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptI"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.956137658856808*^9, 3.9561377231097336`*^9}, {
  3.9561382442049274`*^9, 3.956138247436804*^9}, {3.956138356229286*^9, 
  3.9561383591505737`*^9}},
 CellLabel->
  "In[361]:=",ExpressionUUID->"e8349be3-8608-c84a-9b28-0d6d9300a4c6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.956137707144516*^9, 3.956137723967192*^9}, 
   3.956138180333702*^9, 3.956138248383009*^9, {3.9561383599675064`*^9, 
   3.956138411689094*^9}, 3.959040231594597*^9, 3.9611285407841015`*^9, 
   3.961413076246447*^9},
 CellLabel->
  "Out[361]=",ExpressionUUID->"15c5be21-20cc-41f1-9f94-4369699b2ad8"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"90f85396-ae61-1f41-b228-21ac087054f9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 490, 7, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[1073, 31, 1540, 26, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2638, 61, 200, 4, 66, "Section",ExpressionUUID->"9f6088f9-a2be-3140-964a-e41e398b8645"],
Cell[CellGroupData[{
Cell[2863, 69, 1888, 43, 111, "Input",ExpressionUUID->"dfa71a50-4711-b245-a180-34a181143c58"],
Cell[4754, 114, 760, 18, 33, "Output",ExpressionUUID->"32df8cbd-a801-4046-83e4-252f4e933252"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5551, 137, 725, 20, 49, "Input",ExpressionUUID->"d79dce97-2742-4042-beca-1367e2fb9dc0"],
Cell[6279, 159, 767, 23, 35, "Output",ExpressionUUID->"ae4efc15-2069-4c71-92c5-f46d9e533b0d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7095, 188, 255, 4, 52, "Section",ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-8944aef04ea5"],
Cell[7353, 194, 8218, 215, 503, "Input",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],
Cell[CellGroupData[{
Cell[15608, 414, 360, 6, 52, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[CellGroupData[{
Cell[15993, 424, 60782, 1001, 313, "Input",ExpressionUUID->"9f7389c4-33a2-5c45-89f8-ab6b14bf70cc"],
Cell[76778, 1427, 60704, 999, 317, "Output",ExpressionUUID->"00f1040d-9984-48df-8f14-3302b623b62f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137519, 2431, 528, 11, 49, "Input",ExpressionUUID->"cbc436a4-ceef-904d-95b0-34e8125b049a"],
Cell[138050, 2444, 1106, 32, 35, "Output",ExpressionUUID->"6b587407-a587-489b-b57f-425cc4729fca"]
}, Open  ]],
Cell[139171, 2479, 297, 7, 33, "Text",ExpressionUUID->"b6dde599-e3c0-334a-bc10-bf8a1c438121"],
Cell[CellGroupData[{
Cell[139493, 2490, 414, 11, 29, "Input",ExpressionUUID->"1355c773-57b2-e644-9a56-f51ae54f0eb7"],
Cell[139910, 2503, 2035, 64, 35, "Output",ExpressionUUID->"d1d069f8-bdc8-4155-9a77-2aac316e3f8d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141994, 2573, 160, 3, 66, "Section",ExpressionUUID->"b3f7eaa1-eef4-db4b-b0a8-80b2b8a1c9ee"],
Cell[CellGroupData[{
Cell[142179, 2580, 184, 3, 53, "Subsection",ExpressionUUID->"38d991a1-469d-ab47-803b-cb9aa78e1b2e"],
Cell[142366, 2585, 529, 9, 31, "Text",ExpressionUUID->"7d1c4f19-60e6-8d42-82db-d0262afd8a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[142932, 2599, 498, 8, 37, "Subsection",ExpressionUUID->"0662e858-35c2-8448-ba35-211b8b39d356"],
Cell[CellGroupData[{
Cell[143455, 2611, 762, 17, 43, "Input",ExpressionUUID->"e962ad31-9e0e-9e4c-93f3-0377f4dd0b8a"],
Cell[144220, 2630, 502, 8, 70, "Output",ExpressionUUID->"a9843644-87e6-4866-8050-a286d177e8ec"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[144771, 2644, 525, 8, 37, "Subsection",ExpressionUUID->"d71ab223-05ca-4544-978d-d729463ed014"],
Cell[CellGroupData[{
Cell[145321, 2656, 1092, 21, 43, "Input",ExpressionUUID->"84a9d925-ec0b-2846-a5b8-e4d186c6f2bd"],
Cell[146416, 2679, 256, 4, 70, "Output",ExpressionUUID->"85126cb1-57b5-40e0-8bec-224752ba13b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146709, 2688, 779, 19, 43, "Input",ExpressionUUID->"16e219f4-421d-e744-8c16-405a3b08bb07"],
Cell[147491, 2709, 236, 5, 70, "Output",ExpressionUUID->"82fe17cf-b582-4891-a91f-46b057e7eaa7"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[147776, 2720, 523, 8, 37, "Subsection",ExpressionUUID->"40fca688-7c37-8743-95aa-5edb53bf5423"],
Cell[CellGroupData[{
Cell[148324, 2732, 810, 17, 43, "Input",ExpressionUUID->"62c68820-999e-3549-b47b-6a422829c1ed"],
Cell[149137, 2751, 552, 9, 70, "Output",ExpressionUUID->"fa09ebb2-93d0-43bf-9ed8-d4d0b5e7c2f9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[149726, 2765, 783, 19, 43, "Input",ExpressionUUID->"0388a793-24c8-d949-94c4-d81d546ae728"],
Cell[150512, 2786, 235, 5, 70, "Output",ExpressionUUID->"5afcd25d-ce34-4231-8b06-5452da46e4f9"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150796, 2797, 575, 9, 37, "Subsection",ExpressionUUID->"e505ada7-2e7e-dd48-aa2d-c3724fcf5509"],
Cell[CellGroupData[{
Cell[151396, 2810, 859, 18, 43, "Input",ExpressionUUID->"f0155be2-2f05-cf4e-ae9a-62778914c3a4"],
Cell[152258, 2830, 524, 9, 70, "Output",ExpressionUUID->"e4d331bd-78e9-4e1e-846e-a6d5a63dee32"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152819, 2844, 753, 18, 43, "Input",ExpressionUUID->"4e909f10-304e-f343-b54a-a5539b5aa9fb"],
Cell[153575, 2864, 209, 4, 70, "Output",ExpressionUUID->"14d51f78-009d-4e64-bcc1-fcff5d6d09cb"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153833, 2874, 577, 9, 37, "Subsection",ExpressionUUID->"bce8ffbf-6470-4d4a-b61d-047d9524fe7c"],
Cell[154413, 2885, 482, 10, 52, "Text",ExpressionUUID->"0488d9d0-e123-f34d-b693-77216d22b638"],
Cell[CellGroupData[{
Cell[154920, 2899, 461, 12, 25, "Input",ExpressionUUID->"a8dc1f20-a9fd-534a-8543-04975878eac5"],
Cell[155384, 2913, 6275, 197, 70, "Output",ExpressionUUID->"478dda98-b234-442f-abc2-48e5ce1591b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161696, 3115, 961, 19, 43, "Input",ExpressionUUID->"ca6df69d-1991-314f-8859-cb3767383b03"],
Cell[162660, 3136, 550, 9, 70, "Output",ExpressionUUID->"fb248833-5f67-476f-ad7b-5d3d79bc1bc9"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[163259, 3151, 633, 10, 37, "Subsection",ExpressionUUID->"4aea22f4-776a-be41-a8b9-989777d728b0"],
Cell[163895, 3163, 395, 7, 31, "Text",ExpressionUUID->"12232b8a-f272-b549-8ee8-d7cf7e9e5a6f"],
Cell[CellGroupData[{
Cell[164315, 3174, 509, 12, 25, "Input",ExpressionUUID->"ba228ad3-4f69-3c44-812a-af2cbaadbe1a"],
Cell[164827, 3188, 1372, 40, 70, "Output",ExpressionUUID->"7e9c288c-6140-4b3c-823a-f5c7649c4c86"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166236, 3233, 965, 19, 43, "Input",ExpressionUUID->"64c7e346-1cde-af45-9f8d-c75632ddd3f4"],
Cell[167204, 3254, 574, 9, 70, "Output",ExpressionUUID->"b3541b3c-8b5e-4d3c-befd-b12ac81f1c96"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[167827, 3269, 633, 10, 37, "Subsection",ExpressionUUID->"c1108ee2-c5e2-f04e-b635-fe16a3ab9658"],
Cell[CellGroupData[{
Cell[168485, 3283, 908, 19, 49, "Input",ExpressionUUID->"4c0d9e81-3fb1-fa4b-aca2-a4aadcae1c00"],
Cell[169396, 3304, 526, 9, 33, "Output",ExpressionUUID->"e512d371-7314-4fe7-9ca0-8bb57e43394c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169971, 3319, 623, 9, 37, "Subsection",ExpressionUUID->"457419a0-d4b9-8e49-b136-a41df8c97b0f"],
Cell[CellGroupData[{
Cell[170619, 3332, 908, 19, 49, "Input",ExpressionUUID->"9ca75056-3d9b-bc42-b54c-6a2e5c3b0480"],
Cell[171530, 3353, 526, 9, 33, "Output",ExpressionUUID->"72374a8f-c579-4b4f-8786-7f7280185d06"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[172117, 3369, 211, 4, 52, "Section",ExpressionUUID->"0e10dd37-8104-c94a-8c65-649cdab12f3f"],
Cell[CellGroupData[{
Cell[172353, 3377, 522, 8, 53, "Subsection",ExpressionUUID->"fba59776-9148-5b4f-9075-82284f0661ad"],
Cell[172878, 3387, 231, 4, 33, "Text",ExpressionUUID->"ce4ce0e9-b23f-4647-af94-bee9eb572196"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[173158, 3397, 163, 3, 52, "Section",ExpressionUUID->"e90dccc5-e9f3-874d-913b-b129f6ad583d"],
Cell[CellGroupData[{
Cell[173346, 3404, 436, 7, 53, "Subsection",ExpressionUUID->"d11bcbe3-4466-8d48-8d95-b256984be2d3"],
Cell[CellGroupData[{
Cell[173807, 3415, 781, 20, 43, "Input",ExpressionUUID->"016768b1-05ea-2b45-823e-7a5dd3499771"],
Cell[174591, 3437, 325, 5, 70, "Output",ExpressionUUID->"3dd73583-2daa-48d4-8ae8-d9172d2e3bb6"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[174965, 3448, 482, 7, 37, "Subsection",ExpressionUUID->"6633380b-83f3-f441-b19e-d07114df9870"],
Cell[CellGroupData[{
Cell[175472, 3459, 827, 20, 43, "Input",ExpressionUUID->"1082b01d-c232-1b4d-a8b7-8fb61d00c4b2"],
Cell[176302, 3481, 224, 4, 70, "Output",ExpressionUUID->"fc0a8230-5725-4b61-bddd-4490f21930ac"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[176575, 3491, 487, 7, 37, "Subsection",ExpressionUUID->"18617412-2e36-7240-9798-f3b34cbd7168"],
Cell[CellGroupData[{
Cell[177087, 3502, 832, 20, 43, "Input",ExpressionUUID->"3c72cbc3-5f16-9044-88e8-afb06edba80b"],
Cell[177922, 3524, 224, 4, 70, "Output",ExpressionUUID->"094a49dd-7569-41ae-a422-7ffaee816dff"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[178195, 3534, 487, 7, 37, "Subsection",ExpressionUUID->"b5e6df1a-2082-cc42-bb30-b93687b52e11"],
Cell[CellGroupData[{
Cell[178707, 3545, 832, 20, 43, "Input",ExpressionUUID->"7caf2741-b5fa-c647-9f52-53104212eb4a"],
Cell[179542, 3567, 224, 4, 70, "Output",ExpressionUUID->"a63f64cb-f668-488a-a12a-fb8fd878c909"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[179815, 3577, 564, 8, 37, "Subsection",ExpressionUUID->"7e381a03-af88-b147-986a-ab066250fa85"],
Cell[180382, 3587, 439, 10, 52, "Text",ExpressionUUID->"0f2b9cc4-3b58-b842-99fe-613c93037ba0"],
Cell[CellGroupData[{
Cell[180846, 3601, 412, 11, 25, "Input",ExpressionUUID->"5f506d39-bf71-f34b-acbc-f3aec79462ae"],
Cell[181261, 3614, 2329, 76, 70, "Output",ExpressionUUID->"3b39365b-e23b-4b93-987d-c5665109ca61"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183627, 3695, 908, 21, 43, "Input",ExpressionUUID->"d682c552-036b-6547-b74f-f39f3a9f42e4"],
Cell[184538, 3718, 223, 4, 70, "Output",ExpressionUUID->"05ab13ce-e89b-4a2c-8958-5a41716423cd"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[184810, 3728, 612, 9, 37, "Subsection",ExpressionUUID->"752b74f9-260b-a941-8310-48671f3b7edb"],
Cell[185425, 3739, 238, 6, 33, "Text",ExpressionUUID->"9e500d9b-c6d2-e94e-bba1-5180f2495e0b"],
Cell[CellGroupData[{
Cell[185688, 3749, 412, 11, 29, "Input",ExpressionUUID->"6220077a-98f6-0743-b979-84bae9a737a0"],
Cell[186103, 3762, 2264, 74, 57, "Output",ExpressionUUID->"a5516e21-81e7-4db6-8545-22cbcfa07b6f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188404, 3841, 981, 22, 49, "Input",ExpressionUUID->"52507028-9665-a544-85f3-ac0a3c109c3d"],
Cell[189388, 3865, 226, 4, 33, "Output",ExpressionUUID->"fe50dc51-ca25-4129-8978-aa4426d2a149"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[189675, 3876, 221, 4, 52, "Section",ExpressionUUID->"7d6e6590-ad3b-aa4d-ad91-9f5ad327fd89"],
Cell[CellGroupData[{
Cell[189921, 3884, 748, 11, 53, "Subsection",ExpressionUUID->"989255a1-1383-b542-868f-a49a786558e0"],
Cell[CellGroupData[{
Cell[190694, 3899, 596, 12, 29, "Input",ExpressionUUID->"1c153a5c-4009-fe45-a749-01cd9484889b"],
Cell[191293, 3913, 13012, 404, 171, "Output",ExpressionUUID->"8e609761-250f-4500-8a7e-3ac09f3b5de4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204342, 4322, 560, 14, 29, "Input",ExpressionUUID->"61a22e0d-3fa1-7946-a415-fd7e4b1239e5"],
Cell[204905, 4338, 402, 6, 33, "Output",ExpressionUUID->"216fd11b-86aa-40c7-876a-dd442b3a4828"]
}, Open  ]],
Cell[CellGroupData[{
Cell[205344, 4349, 360, 9, 29, "Input",ExpressionUUID->"eb63601f-c088-de4e-bb6a-54581bac5a47"],
Cell[205707, 4360, 254, 4, 33, "Output",ExpressionUUID->"518e51c1-0c2d-4c0e-b59f-faf2075dda1e"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[206022, 4371, 213, 4, 52, "Section",ExpressionUUID->"432e527b-bb62-1240-8db7-dae7d756a3a5"],
Cell[CellGroupData[{
Cell[206260, 4379, 714, 10, 53, "Subsection",ExpressionUUID->"267d676c-6e13-0042-bf7a-cb90e9b09112"],
Cell[CellGroupData[{
Cell[206999, 4393, 645, 12, 25, "Input",ExpressionUUID->"4ad77f81-e40f-5b4c-9a0b-bf218f58bae7"],
Cell[207647, 4407, 25763, 757, 70, "Output",ExpressionUUID->"18e954d8-a73e-4d0b-b8e5-fc0970438ce1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[233447, 5169, 360, 9, 25, "Input",ExpressionUUID->"734d1d57-5660-bc49-a08f-f32c088ce887"],
Cell[233810, 5180, 250, 4, 70, "Output",ExpressionUUID->"ad3dc591-b8d7-4a7d-b9b0-433a63cfd88d"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[234109, 5190, 760, 11, 37, "Subsection",ExpressionUUID->"80b26708-9c6d-aa4a-a30f-8a688aedef7b"],
Cell[CellGroupData[{
Cell[234894, 5205, 695, 13, 25, "Input",ExpressionUUID->"f14cc723-5f23-404e-b88f-383059162632"],
Cell[235592, 5220, 4690, 145, 70, "Output",ExpressionUUID->"8ab43b9c-1e72-4129-943f-ad70b20a9d69"]
}, Open  ]],
Cell[CellGroupData[{
Cell[240319, 5370, 411, 10, 25, "Input",ExpressionUUID->"f6fca7dc-4d97-d84d-8628-7e2f6ab7cb9d"],
Cell[240733, 5382, 300, 5, 70, "Output",ExpressionUUID->"6dd5093b-8509-419a-ab50-46ad05fbc504"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[241082, 5393, 821, 12, 37, "Subsection",ExpressionUUID->"9252b059-d9a4-c541-93ef-f5f0923c8d80"],
Cell[CellGroupData[{
Cell[241928, 5409, 742, 14, 25, "Input",ExpressionUUID->"f4f5deaa-26fd-e048-ad2a-2a9b8be777f9"],
Cell[242673, 5425, 15195, 461, 70, "Output",ExpressionUUID->"055eddb2-88eb-424d-845f-b3f7c787a1b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[257905, 5891, 462, 11, 25, "Input",ExpressionUUID->"5c96b08b-525b-1e42-a948-91cbf4ebca66"],
Cell[258370, 5904, 321, 5, 70, "Output",ExpressionUUID->"6ebf1e98-cc7d-4df6-8a32-70647363c7da"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[258740, 5915, 858, 12, 37, "Subsection",ExpressionUUID->"6973bef7-b779-9044-992e-bd6df851436b"],
Cell[CellGroupData[{
Cell[259623, 5931, 790, 14, 25, "Input",ExpressionUUID->"44b1a86f-db55-6343-b629-05c83c52c43e"],
Cell[260416, 5947, 29233, 849, 70, "Output",ExpressionUUID->"8b6aacb3-4b8a-41bb-baf4-1b3d960f2b22"]
}, Open  ]],
Cell[CellGroupData[{
Cell[289686, 6801, 462, 11, 25, "Input",ExpressionUUID->"1a411fb9-4961-7445-a011-74471fe1e539"],
Cell[290151, 6814, 352, 6, 70, "Output",ExpressionUUID->"558703f4-abef-4a78-a899-e80b6d2a9701"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[290552, 6826, 860, 12, 37, "Subsection",ExpressionUUID->"d60888f0-9f45-0343-ad43-14ff13743152"],
Cell[CellGroupData[{
Cell[291437, 6842, 790, 14, 29, "Input",ExpressionUUID->"aca079f3-0fa4-dc4e-a7ae-7fda6e3e9bf9"],
Cell[292230, 6858, 23755, 693, 307, "Output",ExpressionUUID->"783d0beb-e6fe-4b20-8601-26d701bded44"]
}, Open  ]],
Cell[CellGroupData[{
Cell[316022, 7556, 462, 11, 29, "Input",ExpressionUUID->"e8349be3-8608-c84a-9b28-0d6d9300a4c6"],
Cell[316487, 7569, 352, 6, 33, "Output",ExpressionUUID->"15c5be21-20cc-41f1-9f94-4369699b2ad8"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]]
}
]
*)

